﻿var smsDistributionWizard = {
    context: $(".v-smsWizard"),
    initialize: function () {
        var self = this;

        $("#Name").trigger("focus");

        $("#Message").a4richTextEditor({
            fullToolbar: false,
            multiLine: false,
            piping: true,
            piping_distribute: true,
            piping_distribute_sms: true
        });

        $(".v-senderOutgoingConfigIdsAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetSenderOutgoingConfigsForAutoComplete", "Distribute"),
            multipleSelection: true,
            altValueField: $("#SenderOutgoingConfigIds")
        });

        $(".page:not(:first)").hide();

        this.toggleAccessExpirationSection($(".h-accessExpiration-select", self.context), false);
    },
    bindEvents: function () {
        var self = this;
        var context = this.context;

        a4ImageSelector.bindElements(context);

        context.on("change", ".h-useBatch", function () {
            var useBatch = $(this).val() == "True";
            $(".v-useBatchDiv", context).toggle(useBatch);
            if (useBatch) {
                $(".v-submit-button").addClass("hidden");
            } else {
                $(".v-submit-button").removeClass("hidden");
                $(".v-batchConfigs").val("");
            }
        });

        context.on("click", ".h-createRecipientList", function () {
            modalDialog.showWindow(a4.getSurveyAction("CreateRecipientList", "Distribute"), 550, 600, { afterClose: function () { smsDistributionWizard.reloadRecipientLists(); } });
        });

        context.on("click", ".h-useSample:not(.disabled)", function () {
            
            $("#RespondentFilterDefinition").val($("#RespondentFilter", smsDistributionWizard.context).val());

            modalDialog.showWindow(a4.getSurveyAction("RespondentFilter", "Shared", {
                respondentFilter: "",
                forDistributions: true,
                excludeEmptyEmails: false,
                excludeEmptyPhones: true
            }), 785, 1050);
        });

        context.on("change", ".h-schedule-select", function () {
            var container = $(this).closest(".field");
            var scheduleType = $(this).val();

            $(".v-specificSchedule", container).toggle($(this).val() == "Specific");

            var date = new Date();

            if (scheduleType == "Tomorrow") {
                date.setDate(date.getDate() + 1);
            }
            else if (scheduleType == "NextWeek") {
                date.setDate(date.getDate() + 7);
            }
            else if (scheduleType == "NotScheduled") {
                date = "";
            }

            $(".datetime", container).datetimepicker("setDate", date);
        });

        context.on("change", ".h-recipientType", function () {
            self.toggleRecipientTypeSection($(this));
        });

        context.on("change", ".h-accessExpiration-select", function () {
            self.toggleAccessExpirationSection($(this), true);
        });

        context.on("keydown", "#Numbers", function () {
            $(".v-numbers-count").text(a4.countPhones($(this).val()));
        });

        context.on("change", "#Numbers", function () {
            $(".v-numbers-count").text(a4.countPhones($(this).val()));
        });

        context.on("keydown", "#NotificationEmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-notification-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("change", "#NotificationEmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-notification-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("click", ".v-expirationCalendarIcon:not(.disabled)", function () {
            $("input.hasDatepicker", $(this).parent()).datepicker('show');
        });

        context.on("change", ".h-imageUrl", function () {
            var image = $(this).val();
            var multimediaPath = $("#MultimediaUrlLink").val();

            if (image != "" && image.indexOf("http") < 0) {
                if (image.indexOf(multimediaPath) < 0) {
                    image = (multimediaPath + image);
                }

                if (image.indexOf("http") < 0) {
                    image = (a4.host + image);
                }

                var protocolEnd = image.indexOf("://") + 3;

                image = image.substring(0, protocolEnd) + image.substring(protocolEnd).replace(/\/\//g, '\/');
                $(this).val(image);
            }
        });

        context.on("change", ".h-schedule-select", function () {
            var container = $(this).closest(".field");
            var input = $(".v-specificSchedule input", container);
            a4.clearInputValidation(input);
        });
    },
    toggleAccessExpirationSection: function (input, clearValue) {
        var expirationSection = input.closest(".v-useAccessExpirationContainer");
        var accessExpiration = $(".v-useAccessExpiration", expirationSection);

        var useAccessExpiration = (input.val() != "None");
        accessExpiration.toggle(useAccessExpiration);

        if (useAccessExpiration) {
            $(".h-accessExpirationLabel", accessExpiration).hide();
            $(".h-accessExpirationLabel[data-section=" + input.val().toLowerCase() + "]", accessExpiration).show();

            var valueField = $(".h-accessExpirationValue", accessExpiration);

            if (clearValue)
                valueField.val("");

            valueField.autoNumeric("destroy");
            valueField.datetimepicker("destroy");

            if (input.val() == "AbsoluteDate") {
                valueField.datetimepicker({ minDate: new Date() });
                valueField.next(".calendarIcon").show();
                valueField.attr('readonly', true);
                valueField.trigger("focus");
            } else {
                valueField.autoNumeric({ aSep: '', aDec: '.', aPad: false });
                valueField.next(".calendarIcon").hide();
                valueField.attr('readonly', false);
            }
        }
    },
    reloadRecipientLists: function () {
        a4.callServerMethod(a4.getSurveyAction("GetRecipientLists", "Distribute"), {}, function (result) {
            var lists = JSON.parse(result);

            if (lists.length > 0) {
                var container = $(".recipient-list .checkbox-list", this.context);
                $(".list-item", container).remove();

                $.each(lists, function (index, value) {
                    var id = "RecipientList_" + (index + 1);
                    var input = $("<input />", { "id": id, "name": "RecipientList", "type": "checkbox", "value": value.Id });
                    var label = $("<label />", { "for": id }).text(value.Label);

                    container.append($("<div />", { "class": "list-item" }).append(input).append(label));
                });
            }
        });
    },
    toggleRecipientTypeSection: function (input) {
        var section = input.attr("data-section");
        var parent = input.closest(".v-recipientTypeContainer");
        $(".v-recipientTypeContainer", parent).hide();
        $(".v-recipientTypeContainer[data-section=" + section + "]", parent).show();
        $(".v-useExclusionListContainer", parent).toggle(section != "sample");
    },
    updatePage: function (page) {
        var pageIndex = page.attr("data-index");

        if (pageIndex == 3) {
            var configIds = $("#SenderOutgoingConfigIds", this.context).val();
            var selectConfigs = $("#SenderOutgoingConfigIds", this.context)
                                .siblings('.autocomplete-container')
                                .find('li.selected-item .item-label')
                                .map(function (i, e) {
                                    return $(this).text();
                                }).get()
                .join(', ');

            var recipientType = $(".h-recipientType:checked", this.context).val();
            var recipients;

            if (recipientType == "Numbers") {
                recipients = $("#Numbers").val();

                if (recipients) {
                    recipients = _.compact(recipients.split(/[\n,;]/g));
                    recipients = recipients.join(", ");
                }
            }
            else {
                recipients = $(".v-sampleDetails").text();
            }

            if (!$("#ScheduleDate", this.context).val()) {
                $("#ScheduleDate", this.context).datetimepicker("setDate", new Date());
            }

            $(".v-previewSender", this.context).text(selectConfigs);
            $(".v-previewRecipient", this.context).text(recipients || "");
            $(".v-previewMessage", this.context).html(a4.decodeHtml($("#Message").a4richTextEditor("getContent")));

            var sd = ($(".h-schedule-select").val() == "NotScheduled") ? $("#NotAvailable").val() : $("#ScheduleDate", this.context).val();
            $(".v-previewSendDate", this.context).text(sd);
        }
    }
}

$(document).ready(function () {
    if (smsDistributionWizard.context.length > 0) {
        smsDistributionWizard.initialize();
        smsDistributionWizard.bindEvents();
        distributionWizard.initializeBase(smsDistributionWizard);
        distributionWizard.bindBaseEvents(smsDistributionWizard);
    }
});
